/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.parser.ParseException;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.StringConstant;
import adql.query.operand.function.ADQLFunction;

public abstract class GeometryFunction
extends ADQLFunction {
    protected ADQLOperand coordSys = null;

    protected GeometryFunction() {
        this.coordSys = null;
    }

    protected GeometryFunction(ADQLOperand aDQLOperand) throws UnsupportedOperationException, NullPointerException, Exception {
        this.setCoordinateSystem(aDQLOperand);
    }

    protected GeometryFunction(GeometryFunction geometryFunction) throws Exception {
        this.coordSys = (ADQLOperand)geometryFunction.coordSys.getCopy();
    }

    public ADQLOperand getCoordinateSystem() {
        return this.coordSys;
    }

    public void setCoordinateSystem(ADQLOperand aDQLOperand) throws UnsupportedOperationException, NullPointerException, ParseException {
        if (aDQLOperand == null) {
            this.coordSys = new StringConstant("");
        } else {
            if (!aDQLOperand.isString()) {
                throw new ParseException("A coordinate system must be a string literal: \"" + aDQLOperand.toADQL() + "\" is not a string operand!");
            }
            this.coordSys = aDQLOperand;
        }
    }

    public static final class GeometryValue<F extends GeometryFunction>
    implements ADQLOperand {
        private ADQLColumn column;
        private F geomFunct;

        public GeometryValue(ADQLColumn aDQLColumn) throws NullPointerException {
            if (aDQLColumn == null) {
                throw new NullPointerException("Impossible to build a GeometryValue without a column or a geometry function !");
            }
            this.setColumn(aDQLColumn);
        }

        public GeometryValue(F f) throws NullPointerException {
            if (f == null) {
                throw new NullPointerException("Impossible to build a GeometryValue without a column or a geometry function !");
            }
            this.setGeometry(f);
        }

        public GeometryValue(GeometryValue<F> geometryValue) throws Exception {
            this.column = geometryValue.column == null ? null : (ADQLColumn)geometryValue.column.getCopy();
            this.geomFunct = geometryValue.geomFunct == null ? null : (GeometryFunction)geometryValue.geomFunct.getCopy();
        }

        public void setColumn(ADQLColumn aDQLColumn) {
            if (aDQLColumn != null) {
                this.geomFunct = null;
                this.column = aDQLColumn;
            }
        }

        public void setGeometry(F f) {
            if (f != null) {
                this.column = null;
                this.geomFunct = f;
            }
        }

        public ADQLOperand getValue() {
            return this.column != null ? this.column : this.geomFunct;
        }

        public boolean isColumn() {
            return this.column != null;
        }

        @Override
        public boolean isNumeric() {
            return this.getValue().isNumeric();
        }

        @Override
        public boolean isString() {
            return this.getValue().isString();
        }

        @Override
        public boolean isGeometry() {
            return this.getValue().isGeometry();
        }

        @Override
        public ADQLObject getCopy() throws Exception {
            return new GeometryValue<F>(this);
        }

        @Override
        public String getName() {
            return this.getValue().getName();
        }

        @Override
        public ADQLIterator adqlIterator() {
            return this.getValue().adqlIterator();
        }

        @Override
        public String toADQL() {
            return this.getValue().toADQL();
        }
    }
}

